/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.mapui;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.IVWProcessCanvasPanel;
import filenet.vw.toolkit.design.mapui.VWDesignerMapNameUtil;
import filenet.vw.toolkit.design.mapui.VWDesignerMapToolbar;
import filenet.vw.toolkit.design.mapui.VWMapMenuItem;
import filenet.vw.toolkit.design.mapui.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class VWToolbarMapsMenu
extends JPopupMenu
implements ActionListener {
    private IVWProcessCanvasPanel m_processCanvasPanel = null;
    private VWDesignerMapToolbar m_designerMapToolbar = null;

    public VWToolbarMapsMenu(IVWProcessCanvasPanel processCanvasPanel, VWDesignerMapToolbar designerMapToolbar) {
        super(VWResource.s_menuMaps_withHK);
        this.m_processCanvasPanel = processCanvasPanel;
        this.m_designerMapToolbar = designerMapToolbar;
    }

    public void releaseReferences() {
        Component[] items = this.getComponents();
        if (items != null) {
            for (int nIndex = 0; nIndex < items.length; ++nIndex) {
                if (!(items[nIndex] instanceof JMenuItem)) continue;
                ((JMenuItem)items[nIndex]).removeActionListener(this);
            }
        }
        this.m_processCanvasPanel = null;
        this.m_designerMapToolbar = null;
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source instanceof VWMapMenuItem) {
            this.m_designerMapToolbar.selectMap(((VWMapMenuItem)source).getMap());
        }
    }

    protected VWMap initMapsMenu(Vector maps) {
        try {
            VWMap selectedMap = null;
            this.removeAll();
            if (maps != null && maps.size() > 0) {
                Object[] mapArray = new Object[maps.size()];
                maps.copyInto(mapArray);
                VWQubbleSort.sort(mapArray);
                VWDesignerMapNameUtil mapNameUtil = new VWDesignerMapNameUtil(this.m_processCanvasPanel.getAuthPropertyData().getMapCache());
                ButtonGroup buttonGrp = new ButtonGroup();
                for (int i = 0; i < mapArray.length; ++i) {
                    VWMap map = (VWMap)mapArray[i];
                    VWMapMenuItem menuItem = new VWMapMenuItem(map, mapNameUtil);
                    menuItem.addActionListener(this);
                    buttonGrp.add(menuItem);
                    if (VWStringUtils.compare(map.getName(), "Workflow") == 0) {
                        this.add((Component)menuItem, 0);
                        selectedMap = map;
                        menuItem.setSelected(true);
                        continue;
                    }
                    this.add(menuItem);
                }
            }
            ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(o);
            return selectedMap;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected VWMapMenuItem findMapMenuItem(String mapName) {
        Component[] items = this.getComponents();
        if (items != null) {
            for (int nIndex = 0; nIndex < items.length; ++nIndex) {
                VWMapMenuItem mapMenuItem;
                if (!(items[nIndex] instanceof VWMapMenuItem) || VWStringUtils.compare(mapName, (mapMenuItem = (VWMapMenuItem)items[nIndex]).getMap().getName()) != 0) continue;
                return mapMenuItem;
            }
        }
        return null;
    }

    protected VWMap getSelectedMap() {
        Component[] items = this.getComponents();
        if (items != null) {
            for (int nIndex = 0; nIndex < items.length; ++nIndex) {
                VWMapMenuItem mapMenuItem;
                if (!(items[nIndex] instanceof VWMapMenuItem) || !(mapMenuItem = (VWMapMenuItem)items[nIndex]).isSelected()) continue;
                return mapMenuItem.getMap();
            }
        }
        return null;
    }
}

